-- events for main menu


function OnLoad ()
	SetProperty ("/Stats:enter_trans_duration", 0.4);
	SetProperty ("/Stats:leave_trans_duration", 0.4);
	CacheSound ("ui/sfx/panel_move.ogg");
	SetProperty ("/:enable_event_on_cursor_enter", 1);

end;



function UpdateTrophies ()

	i = 1;
	while (i <= 7) do
		prop = "trophy"..i;
		id  = Azkend_GetTrophyIdByIndex (i);
		name = Azkend_GetTrophyName (id);
		bitmap = Azkend_GetTrophyBitmap (id);
		status = Azkend_GetTrophyStatus (id);

		if (status == 0) then
			SetProperty (prop..":button.bm_icon", "!NONE");
		else
			SetProperty (prop..":button.bm_icon", bitmap);
		end;
		SetProperty (prop..":visible", 1);--status);

		i = i + 1;
	end; 

end;



function GetStat (name)
	local value = GetProfileVar (name);
	if (value == nil) then
		return 0;
	end;
	return value;
end;

function UpdateStatLabelNumber (name)
	SetProperty (name .. ":label.text", LocalizeNumber (GetStat (name)));
end;

function UpdateStatLabelTime (name)
	SetProperty (name .. ":label.text", GetFormattedTime (GetStat (name), "HH:MM:SS"));
end;

function UpdateStats ()

	--
	-- expert ranks
	local num_expert_ranks = 0;
	local i = 1;
	while (i <= 7*10) do
		local value = GetProfileVar ("LevRank"..i);
		if (value == "1" or value == "2") then
			num_expert_ranks = num_expert_ranks + 1;
		end;
		i = i + 1;
	end;
	
	local rating = 100 * num_expert_ranks / (7*10);
	SetProperty ("StatExpertLevelRanks:label.text", string.format ("%u", rating) .. "%");
	
	SetProfileVar ("StatTotalTimePlayed", GetProfileValue ("total_play_time"));
	
	--
	-- the rest
	UpdateStatLabelNumber ("StatTilesMatched");
	UpdateStatLabelTime ("StatTotalTimePlayed");
	UpdateStatLabelNumber ("StatLevelsCompleted");
	UpdateStatLabelNumber ("StatPowerupsActivated");
	UpdateStatLabelNumber ("StatLongestChain");
	
end;


function OnEnter ()

	PlaySound ("ui/sfx/panel_move.ogg");
	UpdateTrophies ();
	UpdateStats ();
end;

function OnLeave ()
    
end;


function OnClick (name)

	Print ("OnClick " .. name .. "\n");
	
	if (name == "Ok") then
	    	PlaySound ("ui/sfx/panel_move.ogg");
				PopScreen ();
		return;
	end;

end;


function OnCursorEnter (name)

	SetProperty ("desc:label.text", T_INFO_MOUSE_OVER);

	  

	if (string.find(name, "trophy%d")) then
		num = string.sub (name, 7);
		id  = Azkend_GetTrophyIdByIndex (num);
		name = Azkend_GetTrophyName (id);
		desc = Azkend_GetTrophyDesc (id);

		SetProperty ("trophy_name:label.text", name);
		SetProperty ("trophy_desc:label.text", desc);
	end;
end;




function OnUpdate (tdelta)

	akey = GetActiveScreenAnimKey ();

	trans = math.sin (0.5*3.1415926535 * GetActiveScreenTransPhase ());
	SetProperty ("panel:position_offset.y", (1-trans) * 200);
	SetProperty ("panel:alpha", trans);
	SetProperty ("fader:alpha", trans + trans * 0.05 * math.sin (2*3.141592*akey));

end;

function OnDraw ()

end;
